### Name: clines
### Title: Calculate Contour Lines
### Aliases: clines
### Keywords: dplot

### ** Examples

# Mount Maungawhau
data("volcano")
rx <- range(x <- 10*1:nrow(volcano))
ry <- range(y <- 10*1:ncol(volcano))
ry <- ry + c(-1,1) * (diff(rx) - diff(ry))/2
tcol <- terrain.colors(12)
plot(x = 0, y = 0,type = "n", xlim = rx, ylim = ry, xlab = "", ylab = "")
u <- par("usr")
rect(u[1], u[3], u[2], u[4], col = tcol[8], border = "red")

line.list <- clines(x, y, volcano)

contour(x, y, volcano, col = tcol[2], lty = "solid", add = TRUE,
        vfont = c("sans serif", "plain"))

templines <- function(clines) {
  lines(clines[[2]], clines[[3]])
}  
invisible(lapply(line.list, templines))



