kendall.w              package:concord              R Documentation

_K_e_n_d_a_l_l'_s _W _c_o_e_f_f_i_c_i_e_n_t _o_f _c_o_n_c_o_r_d_a_n_c_e

_D_e_s_c_r_i_p_t_i_o_n:

     calculates Kendall's W coefficient of concordance

_U_s_a_g_e:

      kendall.w(x,lambda,descending=TRUE,ranks=FALSE)

_A_r_g_u_m_e_n_t_s:

       x: matrix of scores or ranks

  lambda: optional contrast coefficient vector or matrix

descending: whether high (default) or low scores represent top ranks

   ranks: whether the values in 'x' are scores or ranks

_D_e_t_a_i_l_s:

     'kendall.w' will accept either a matrix or data frame of scores or
     ranks where the rows represent methods (usually raters) and the
     columns represent data objects. It will handle ties, but not
     missing values. By default it  assumes that numerically higher
     scores represent numerically lower ranks. A vector or matrix of
     contrast coefficients (which each must sum to zero) may  be
     supplied. A z-score approximation of the significance of each
     contrast will be displayed if 'lambda' is present. The 'ranks'
     argument allows the user to pass ranks directly to the function.
     If ranks are passed without setting 'ranks' to TRUE and with
     'descending' TRUE, the order of the ranks will be reversed. For
     small values of k (methods), 'kendall.w'  will try to lookup the
     tabled values for significance. For 'k' greater than 7, a
     chi-squared approximation is returned. Only one of these values
     will be returned.

_V_a_l_u_e:

       W: value of W

 p.table: whether the obtained W exceeded the table value for small N

 p.chisq: the probability of the obtained chi-squared value for larger
          N

_N_o_t_e:

     Kendall's W may not be appropriate for nominal class data.

_A_u_t_h_o_r(_s):

     Jim Lemon

_R_e_f_e_r_e_n_c_e_s:

     Siegel, S. & Castellan, N.J.Jr. (1988) Nonparametric statistics
     for the behavioral sciences. Boston, MA: McGraw-Hill.

_S_e_e _A_l_s_o:

     'kripp.alpha','cohen.kappa'

_E_x_a_m_p_l_e_s:

      # fictional rankings of job applicants
      app.mat<-matrix(c(1,3,4,2,6,5,2,4,3,1,5,6,3,2,5,1,5,4),nrow=3,byrow=TRUE)
      # Test the hypothesis that the first three applicants are ranked higher
      # than the last three.
      lambda<-c(1,1,1,-1,-1,-1)
      print(kendall.w(app.mat,lambda))

