### Name: BayesCslogistic
### Title: Perform a Bayesian Analysis of a conditionally specified
###   logistic regression model
### Aliases: BayesCslogistic
### Keywords: regression

### ** Examples

# simulated data set

library(mvtnorm)

n<-400
mu1<-c(-1.5,-0.5)
Sigma1<-matrix(c(1, -0.175,-0.175,1),ncol=2)
age<-as.vector(sample(seq(5,6,0.1),n,replace=TRUE))
beta1<-0.2

z<-rmvnorm(n,mu1,Sigma1)
zz<-cbind(z[,1]+beta1*age,z[,2]+beta1*age)
datos<-cbind(zz[,1]>0,zz[,2]>0,age)
colnames(datos)<-c("y1","y2","age")
data0<-data.frame(datos)
attach(data0)

# equal effect of age for all the covariates

y<-cbind(y1,y2)

fit0<-BayesCslogistic(y~age)
fit0
summary(fit0)
plot(fit0)

# different effects: only intercept

fit1<-BayesCslogistic(y~age,type=FALSE)
fit1
summary(fit1)
plot(fit1)

# different effects: all the covariates

fit2<-BayesCslogistic(y~age,type=FALSE,intercept=FALSE)
fit2
summary(fit2)
plot(fit2)




