mult.fig.p              package:cwhplot              R Documentation

_P_l_o_t _S_e_t_u_p _f_o_r _M_U_L_T_i_p_l_e _F_I_G_u_r_e_s, _i_n_c_l. _M_a_i_n _T_i_t_l_e

_D_e_s_c_r_i_p_t_i_o_n:

     Easy Setup for plotting multiple figures (in a rectangular layout)
     on one page.  It allows to specify a main title, a bottom line,
     and uses _smart_ defaults for several 'par' calls.

_U_s_a_g_e:

     mult.fig.p(nr.plots, mfrow, mfcol,
              marP = rep(0, 4),  mgp = c(1.5, 0.6, 0),
              mar = marP + 0.1 + c(4, 4, 2, 1),
              main = NULL, sub = NULL, adj.sub = 0.5,
              tit.wid = if (is.null(main)) 0 else 1 + 1.5*cex.main,
              quiet = .Device == "postscript",
              cex.main = par("cex.main"),
              col.main = par("col.main"),
              font.main = par("font.main"), ...)

_A_r_g_u_m_e_n_t_s:

nr.plots: integer; the number of plot figures you'll want to draw.

   mfrow: _instead_ of 'nr.plots': integer(2) vector giving the
          rectangular figure layout for 'par(mfrow= .)'

   mfcol: _instead_ of 'nr.plots': integer(2) vector giving the
          rectangular figure layout for 'par(mfcol= .)'

    marP: numeric(4) vector of figure margins to _add_ (``*P*lus'') to
          default 'mar', see below.

     mgp: argument for 'par(mpg= .)' with a smaller default than usual.

     mar: argument for 'par(mar= .)' with a smaller default than usual,
          using the 'marP' argument, see above.

    main: character.  The main title to be used for the whole graphic.

     sub: character.  The bottom line to be used for the whole graphic.

 adj.sub: The value of adj determines the way in which 'sub' is
          justified. A value of 0 produces left-justified text, 0.5
          centered text and 1 right-justified text. See 'par(adj= .)'

 tit.wid: numeric; the vertical width to be used for the main title.

   quiet: Suppress request to restore graphical parameters.

cex.main: numeric; the character size to be used for the main title.

col.main: string; name of the color to be used for the main title.

font.main: numeric; number of the font to be used for the main title.

     ...: Further arguments to 'mtext' for  'main' and  'sub'.

_V_a_l_u_e:

     A 'list' with two components that are lists themselves, a subset
     of 'par()', 

 new.par: the current 'par' settings.

 old.par: the 'par' _before_ the call.

_A_u_t_h_o_r(_s):

     Martin Maechler, maechler@stat.math.ethz.ch,
      modified by Christian W. Hoffmann, christian.hoffmann@wsl.ch

_S_e_e _A_l_s_o:

     'par', 'layout'.

_E_x_a_m_p_l_e_s:

     mult.fig.p(5, main= "Sinus Funktionen verschiedener Frequenzen")
     x <- seq(0, 1, len = 201)
     for (n in 1:5)
       plot(x, sin(n * pi * x), ylab ="", main = paste("n = ",n))
     par(old.par)

     rr <- mult.fig.p(mfrow=c(5,1), main= "Sinus Funktionen", cex = 1.5,
                    marP = - c(0, 1, 2, 0))
     for (n in 1:5)
       plot(x, sin(n * pi * x), type = 'l', col="red", ylab ="")
     str(rr)
     par(old.par)
     ## Look at the par setting *AFTER* the above:
     str(do.call("par", as.list(names(rr$new.par))))

