### Name: printP
### Title: Print without square brackets, expression values together with
###   their call strings
### Aliases: printP catn mpf pn prinV prinM prinT prinE prinL prinP NprinV
###   NprinM NprinT NprinE NprinL NprinP
### Keywords: print

### ** Examples

mpf(pi,5); mpf(-pi,5)

xx <- options(digits=7)
x <- matrix(c(5,3,2,7,8.235,exp(1),pi,0,99),3,3)
m <- matrix(c("a","b c","d","ff"," x","","7","8","99"),3,3)
dimnames(x) <- list(c("r1","r2","r3"),c("c1","c2","c3"))

#### In file  T.Rnw:
##  <<echo=TRUE>>=
a <- -2; b <- -4; c <- 7
##  @ 
##  
##  The coefficients are: $a = \Sexpr{a}$, $b = \Sexpr{b}$, $c = \Sexpr{c}$.
##  

##  For the linear combination $$z = a + bx +cy$$ we have
##   $$z = \Sexpr{sprintf(%.4f,a)} \Sexpr{mpf(b,3)} x \Sexpr{mpf(c,5)} y$$
#### end T.Rnw
###  Sweave: T.Rnw .. T.tex .. T.dvi

prinV(as.vector(x))
#  5.00  3.00  2.00  7.00  8.24  2.72  3.14  0.00 99.00 

prinM(x,,3)
#  5.00  7.00  3.14 
#  3.00  8.24  0.00 
#  2.00  2.72 99.00 

prinT(x,TRUE,TRUE)
#       c1      c2      c3 
# r1    5       7       3.14159265358979 
# r2    3       8.235   0 
# r3    2       2.71828182845905        99 

prinT(c(c1="a",c2="b c",c3="d",c4="ff",c5=" x"),TRUE)
# c1    c2      c3      c4      c5 
# a     b c     d       ff       x      # the tabs are not visible here

prinT(c(c1=5,c2=7,c3=1,c4=3),TRUE)
# 5     7       1       3      # the tabs are not visible here

####prinE("x")
# x =[1]  5.000000  3.000000  2.000000  7.000000  8.235000  2.718282  3.141593
# [8]  0.000000 99.000000

####prinE("'This is a comment: ';3+5;pi-3",digits=4)
# 'This is a comment: ';3+5;pi-3 =[1] 0.1416

prinL("x")
# x 
#        c1       c2        c3
# r1  5 7.000000  3.141593
# r2  3 8.235000  0.000000
# r3  2 2.718282 99.000000

catt <- function(x) {cat("This function will write '",x,"' on one line\n") }
y <- prinP("catt(32)");
# catt(32) 
# This function will write ' 32 ' on one line

####prinE("y ")
# y =[1] "catt(32)"

prinL("y ")
# y  
# [1] "catt(32)"

prinP("y ")
# y 
 
options(digits=xx$digits)



