### Name: dX
### Title: First derivatives from harmonic fits.
### Aliases: dX dY dT test.dX test.dY test.dT
### Keywords: manip

### ** Examples

# Construct a test series:
t <- seq(-3,3,by=0.1)
nt <- length(t)
y <- 2*rnorm(nt) + 10*sin(t/4) - 7*sin(t/3) + 4*cos(t) - sin(2*t) + 2*cos(3*t) + 0.5*sin(4*t)
plot(y)

dydt <- dT(y)
lines(dydt$y.fit,col="red")
dydt.2 <- dT(y,maxhar=3)
lines(dydt.2$y.fit,col="blue",lty=2)

# First derivative
plot(dydt$dy,type="l")
lines(dydt.2$dy,col="blue",lty=2)

# Second derivative
dy2dt2<-dT(dydt$dy)
dy2dt2.2<-dT(dydt.2$dy)
plot(dy2dt2$dy,type="l")
lines(dy2dt2.2$dy,col="blue",lty=2)



