### Name: Regression-gradients
### Title: REGression based CALculus for empirical data
### Aliases: coefFit coefDeriv coefInt geoGrad testReg.cal derivFFT
###   integrFFT testFFTcalc
### Keywords: manip

### ** Examples

## Not run: 
##D # Polynomial series calculus. (testReg.cal)
##D   library(clim.pact)
##D   load("data/etopo5_scandinavia.Rdata")
##D   y <- ROSE[i.y,]
##D   a <- coefFit(y,n=N)
##D   da <- coefDeriv(a)
##D   a.2 <- coefInt(da,c1=a$coefs[1])
##D   newFig()
##D   plot(ETOPO5X,y,type="s",lwd=3,xlab="Longitude (degE)",ylab="m.a.s.l.",
##D        main=paste("Transect: ",round(ETOPO5Y[i.y],1),"degE"))
##D   polygon(c(ETOPO5X,ETOPO5X[1320],ETOPO5X[1]),
##D           c(da$y.deriv/quantile(da$y.deriv,0.9)*quantile(y,0.7),0,0),col="blue")
##D   lines(ETOPO5X,y,type="s",lwd=4)
##D   lines(ETOPO5X,a$y.hat,col="red",lty=2,lwd=2)
##D   lines(ETOPO5X,a.2$y.int,col="steelblue",lty=1)
##D 
##D # FFT-based calculus  (testFFTcalc)
##D 
##D x <- seq(-3,3,length=100)
##D y <- 3*cos(5*x) + 0.3*sin(18*x) - 1.4*sin(3*x) + 0.15*sin(23*x)
##D plot(x,y,type="l",lwd=3)
##D grid()
##D dydx <- deriv.fft(y)
##D y2 <- integr.fft(dydx)
##D lines(x,y2,col="red",lty=2,lwd=2)
##D grid()
##D newFig()
##D plot(x,Im(dydx),type="l",lwd=3)
##D grid()
##D lines(x,rep(0,length(x)),col="grey")  
## End(Not run)



