### Name: glm.binomial.disp
### Title: Overdispersed binomial logit models.
### Aliases: glm.binomial.disp
### Keywords: models regression

### ** Examples

data(orobanche)
attach(orobanche)
h <- factor(host)
v <- factor(variety, levels=c("O.a75", "O.a73"))

mod <- glm(cbind(germinated, seeds-germinated) ~ h + v + h*v, family=binomial(logit))
summary(mod)

mod.disp <- glm.binomial.disp(mod)
summary(mod.disp)
mod.disp$dispersion



