### Name: E
### Title: Generic Function for the Computation of (Conditional)
###   Expectations
### Aliases: E E-methods E,UnivariateDistribution,missing,missing-method
###   E,AbscontDistribution,missing,missing-method
###   E,DiscreteDistribution,missing,missing-method
###   E,MultivariateDistribution,missing,missing-method
###   E,DiscreteMVDistribution,missing,missing-method
###   E,UnivariateDistribution,function,missing-method
###   E,AbscontDistribution,function,missing-method
###   E,DiscreteDistribution,function,missing-method
###   E,MultivariateDistribution,function,missing-method
###   E,DiscreteMVDistribution,function,missing-method
###   E,UnivariateCondDistribution,missing,numeric-method
###   E,AbscontCondDistribution,missing,numeric-method
###   E,DiscreteCondDistribution,missing,numeric-method
###   E,UnivariateCondDistribution,function,numeric-method
###   E,AbscontCondDistribution,function,numeric-method
###   E,DiscreteCondDistribution,function,numeric-method
###   E,Beta,missing,missing-method E,Binom,missing,missing-method
###   E,Cauchy,missing,missing-method E,Chisq,missing,missing-method
###   E,Dirac,missing,missing-method E,Exp,missing,missing-method
###   E,Fd,missing,missing-method E,Gammad,missing,missing-method
###   E,Geom,missing,missing-method E,Hyper,missing,missing-method
###   E,Logis,missing,missing-method E,Lnorm,missing,missing-method
###   E,Nbinom,missing,missing-method E,Norm,missing,missing-method
###   E,Pois,missing,missing-method E,Td,missing,missing-method
###   E,Unif,missing,missing-method E,Weibull,missing,missing-method
### Keywords: methods distribution

### ** Examples

# mean of Exp(1) distribution
E <- Exp() 

E(E) ## uses explicit terms
E(as(E,"AbscontDistribution")) ## uses numerical integration
E(as(E,"UnivariateDistribution")) ## uses simulations
E(E, fun = function(x){2*x^2}) ## uses simulations

# the same operator for discrete distributions:
P <- Pois(lambda=2)

E(P) ## uses explicit terms
E(as(P,"DiscreteDistribution")) ## uses sums
E(as(P,"UnivariateDistribution")) ## uses simulations
E(P, fun = function(x){2*x^2}) ## uses simulations

# second moment of N(1,4)
E(Norm(mean=1, sd=2), fun = function(x){x^2})
E(Norm(mean=1, sd=2), fun = function(x){x^2}, useApply = FALSE)

# conditional distribution of a linear model
D1 <- LMCondDistribution(theta = 1) 
E(D1, cond = 1)
E(Norm(mean=1))
E(D1, function(x){x^2}, cond = 1)
E(Norm(mean=1), fun = function(x){x^2})
E(D1, function(x, cond){cond*x^2}, cond = 2, withCond = TRUE, useApply = FALSE)
E(Norm(mean=2), function(x){2*x^2})



