### Name: var
### Title: Generic Function for the Computation of Functionals
### Aliases: var var-methods var,ANY-method
###   var,UnivariateDistribution-method var,Beta-method var,Binom-method
###   var,Cauchy-method var,Chisq-method var,Dirac-method var,Exp-method
###   var,Fd-method var,Gammad-method var,Geom-method var,Hyper-method
###   var,Logis-method var,Lnorm-method var,Nbinom-method var,Norm-method
###   var,Pois-method var,Unif-method var,Weibull-method var,Td-method sd
###   sd-methods sd,UnivariateDistribution-method median median,ANY-method
###   median-methods median,UnivariateDistribution-method IQR IQR-methods
###   IQR,ANY-method IQR,UnivariateDistribution-method mad mad,ANY-method
###   mad-methods mad,UnivariateDistribution-method
### Keywords: methods distribution

### ** Examples

# Variance of Exp(1) distribution
var(Exp())

#median(Exp())
IQR(Exp())
mad(Exp())

# Variance of N(1,4)^2
var(Norm(mean=1, sd=2), fun = function(x){x^2})
var(Norm(mean=1, sd=2), fun = function(x){x^2}, useApply = FALSE)

## sd -- may equivalently be replaced by var
sd(Pois()) ## uses explicit terms
sd(as(Pois(),"DiscreteDistribution")) ## uses sums
sd(as(Pois(),"UnivariateDistribution")) ## uses simulations
sd(Norm(mean=2), fun = function(x){2*x^2}) ## uses simulations
#
mad(sin(exp(Norm()+2*Pois()))) ## weird



