### Name: liesInSupport
### Title: Generic Function for Testing the Support of a Distribution
### Aliases: liesInSupport liesInSupport-methods
###   liesInSupport,DiscreteDistribution,numeric-method
###   liesInSupport,DiscreteDistribution,matrix-method
###   liesInSupport,AbscontDistribution,numeric-method
###   liesInSupport,AbscontDistribution,matrix-method
###   liesInSupport,DiscreteMVDistribution,numeric-method
###   liesInSupport,DiscreteMVDistribution,matrix-method
### Keywords: distribution

### ** Examples

liesInSupport(Exp(1), rnorm(10))

# note
x <- rpois(10, lam = 10)
liesInSupport(Pois(1), x)
# better
distroptions("TruncQuantile"=1e-15)
liesInSupport(Pois(1), x)
distroptions("TruncQuantile"=1e-05) # default

M <- matrix(rpois(30, lam = 10), ncol = 3)
D1 <- DiscreteMVDistribution(M)
M1 <- rbind(r(D1)(10), matrix(rpois(30, lam = 10), ncol = 3))
liesInSupport(D1, M1)



