### Name: eco
### Title: Fitting the Parametric Bayesian Model of Ecological Inference in
###   2x2 Tables
### Aliases: eco
### Keywords: models

### ** Examples


## load the registration data
data(reg)

## NOTE: convergence has not been properly assessed for the following
## examples. See Imai and Lu (2004, 2005) for more complete analyses.

## fit the parametric model with the default prior specification
res <- eco(Y ~ X, data = reg, verbose = TRUE)
## summarize the results
summary(res)

## obtain out-of-sample prediction
out <- predict(res, verbose = TRUE)
## summarize the results
summary(out)

## load the Robinson's census data
data(census)

## fit the parametric model with contextual effects and N 
## using the default prior specification
res1 <- eco(Y ~ X, N = N, context = TRUE, data = census, verbose = TRUE)
## summarize the results
summary(res1)

## obtain out-of-sample prediction
out1 <- predict(res1, verbose = TRUE)
## summarize the results
summary(out1)




