### Name: edgecluster
### Title: Edge detection in noisy images
### Aliases: edgecluster
### Keywords: robust multivariate nonparametric

### ** Examples

  y <- matrix(rep(0,60*60),nrow=60)
  y[21:40,21:40]<-1
  y <- y + matrix(rnorm(60*60,0,0.2),nrow=60)
  image(y,col=gray(seq(0,1,1/255)))

  ec <- edgecluster(y,0.05,0.05,0.7,
                    estimator="M_median",kernel="gauss")
  plot(bestMclust(ec[[1]],4),ec[[2]],xlim=c(0,1),ylim=c(0,1))



