### Name: eqdist.etest
### Title: Multisample E-statistic (Energy) Test of Equal Distributions
### Aliases: eqdist.etest
### Keywords: multivariate htest nonparametric

### ** Examples

 data(iris)
 
 ## test if the 3 varieties of iris data (d=4) have equal distributions
 eqdist.etest(iris[,1:4], c(50,50,50), R = 199)

 ## compare incomplete versions of two sample test
 x <- c(rpois(400, 2), rnbinom(600, size=1, mu=2))
 eqdist.etest(x, c(400, 600), incomplete=TRUE, N=100, R = 199)
 eqdist.etest(x, c(400, 600), incomplete=TRUE, N=200, R = 199)
  
## Don't show: 
  x <- matrix(rnorm(200), nrow=40)
  y <- matrix(rnorm(250, mean=5), nrow=50)
  x <- rbind(x, y)
  eqdist.etest(dist(x), sizes=c(40, 50), distance=TRUE, R = 19)
  eqdist.etest(x, sizes=c(40, 50), incomplete=TRUE, N=50, R = 19)
## End Don't show



