### Name: Independence E-test
### Title: Energy Statistic Test of Independence
### Aliases: indep.e indep.etest
### Keywords: htest

### ** Examples

 ## independent multivariate data
 x <- matrix(rnorm(60), nrow=20, ncol=3)
 y <- matrix(rnorm(40), nrow=20, ncol=2)
 indep.e(x, y)
 indep.etest(x, y, R = 99)
 
 ## dependent bivariate data
 library(MASS)
 Sigma <- matrix(c(1, .5, .5, 1), 2, 2)
 x <- mvrnorm(30, c(0, 0), Sigma)
 indep.etest(x[,1], x[,2], R = 99)



