### Name: CRPS
### Title: Calculate the Continuous Ranked Probability Score for an
###   ensemble forecast.
### Aliases: CRPS
### Keywords: file

### ** Examples

#read in the sea-level pressure data and calculate BMA estimates
#for forecasting on the 35th day in the data set
data(slp)
unique.dates <- unique(slp$date)
date.list <- NULL

for(i in 1:length(unique.dates))
{
  date.list[slp$date==unique.dates[i]] <- i
}

X <- cbind(slp$F1,slp$F2,slp$F3,slp$F4,slp$F5)
Y <- slp$Y

EMresult <- EM.for.date(date = 35,date.list = date.list,X = X,Y = Y )

#now calculate the CRPS over the training period (observations 43 through 161)
CRPS(a = EMresult$a,b = EMresult$b, sigma = EMresult$sigma, w =  EMresult$w, X=X[43:161,], Y=Y[43:161])

#calculate the BMA estimates without CRPS minimization, and compare the new CRPS score
EMresult.without <- EM.for.date(date = 35,date.list = date.list,X = X,Y = Y, min.CRPS=FALSE )
CRPS(a = EMresult.without$a,b = EMresult.without$b, sigma = EMresult.without$sigma, w =  EMresult.without$w, X=X[43:161,], Y=Y[43:161])




