### Name: EM.normals
### Title: EM algorithm for a BMA mixture of normals
### Aliases: EM.normals
### Keywords: file

### ** Examples


#create a simulated dataset with equal weights, no bias,
#and standard deviation of 1 in each component
x <- matrix(rnorm(1000,0,2),nrow = 200, ncol = 5)

y.latent <- floor(runif(200,1,6))
y.means <- NULL
for(i in 1:200)
{
  y.means[i] <- x[i,y.latent[i]]
}
y <- rnorm(200,y.means, sd = 1)

#calculate the BMA estimates of the parameters
EMresult <- EM.normals(x, y, reg.adjust=FALSE, min.CRPS=FALSE)

#read in the sea-level pressure data and calculate BMA estimates
#for forecasting on the 35th day in the data set
#(this requires training on observations 43 through 161)
data(slp)
unique.dates <- unique(slp$date)
date.list <- NULL

for(i in 1:length(unique.dates))
{
  date.list[slp$date==unique.dates[i]] <- i
}

X <- cbind(slp$F1,slp$F2,slp$F3,slp$F4,slp$F5)
Y <- slp$Y

#calculate the BMA estimates of the parameters
EMresult <- EM.normals(X = X[43:161,],Y = Y[43:161] )




