### Name: bmacdf
### Title: Find the BMA cdf at x for the K-component BMA mixture of normals
### Aliases: bmacdf
### Keywords: file

### ** Examples

#create a simulated dataset with equal weights, no bias,
#and standard deviation of 1 in each component
x <- matrix(rnorm(1000,0,2),nrow = 200, ncol = 5)

y.latent <- floor(runif(200,1,6))
y.means <- NULL
for(i in 1:200)
{
  y.means[i] <- x[i,y.latent[i]]
}
y <- rnorm(200,y.means, sd = 1)

#calculate the BMA estimates of the parameters
EMresult <- EM.normals(x, y, reg.adjust=FALSE, min.CRPS=FALSE)

#evaluate and plot the BMA cdf for the first observation
index <- seq(-5,5,by=.1)
cdf.at.index=NULL
for(i in 1:length(index))
{
  cdf.at.index[i]=bmacdf(a = EMresult$a,b = EMresult$b, sigma = EMresult$sigma,
  w =  EMresult$w, x[1,],index[i])
}
plot(index, cdf.at.index, type="l")

#read in the sea-level pressure data and calculate BMA estimates
#for forecasting on the 35th day in the data set
data(slp)
unique.dates <- unique(slp$date)
date.list <- NULL

for(i in 1:length(unique.dates))
{
  date.list[slp$date==unique.dates[i]] <- i
}

X <- cbind(slp$F1,slp$F2,slp$F3,slp$F4,slp$F5)
Y <- slp$Y

EMresult <- EM.for.date(date = 35,date.list = date.list,X = X,Y = Y )

#evaluate and plot the BMA cdf for the first observation
index <- seq(1000,1025,by=.1)
cdf.at.index=NULL
for(i in 1:length(index))
{
  cdf.at.index[i]=bmacdf(a = EMresult$a,b = EMresult$b, sigma = EMresult$sigma,
  w =  EMresult$w, X[1,],index[i])
}
plot(index, cdf.at.index, type="l")




