### Name: bmaquant
### Title: Find a specific quantile of a BMA mixture of normal
###   distributions
### Aliases: bmaquant
### Keywords: file

### ** Examples

#create a simulated dataset with equal weights, no bias,
#and standard deviation of 1 in each component
x <- matrix(rnorm(1000,0,2),nrow = 200, ncol = 5)

y.latent <- floor(runif(200,1,6))
y.means <- NULL
for(i in 1:200)
{
  y.means[i] <- x[i,y.latent[i]]
}
y <- rnorm(200,y.means, sd = 1)

#calculate the BMA estimates of the parameters
EMresult <- EM.normals(x, y, reg.adjust=FALSE, min.CRPS=FALSE)

# 95th percentile
bmaquant(a = EMresult$a,b = EMresult$b, sigma = EMresult$sigma,
w =  EMresult$w, alpha = .95, x[1,])

# 5th percentile
bmaquant(a = EMresult$a,b = EMresult$b, sigma = EMresult$sigma,
w =  EMresult$w, alpha = .05 ,x[1,])

#read in the sea-level pressure data and calculate BMA estimates
#for forecasting on the 35th day in the data set
data(slp)
unique.dates <- unique(slp$date)
date.list <- NULL

for(i in 1:length(unique.dates))
{
  date.list[slp$date==unique.dates[i]] <- i
}

X <- cbind(slp$F1,slp$F2,slp$F3,slp$F4,slp$F5)
Y <- slp$Y

EMresult <- EM.for.date(date = 35,date.list = date.list,X = X,Y = Y )

# 5th and 95th percentiles
bmaquant(a = EMresult$a,b = EMresult$b, sigma = EMresult$sigma,
w =  EMresult$w, alpha = c(.05,.95) ,X[1,])




