### Name: GpdDistribution
### Title: GPD Distributions for Extreme Value Theory
### Aliases: GpdDistribution dgpd pgpd qgpd rgpd
### Keywords: distribution

### ** Examples

## SOURCE("fExtremes.53A-GpdModelling")

## *gpd  -
   xmpExtremes("\nStart: Simulate GPD Distributed sample >")
   par(mfrow = c(2, 2))
   r = rgpd(n = 1000, xi = 1/4)
   plot(r, type = "l", main = "GPD Series")
   
## Plot empirical density and compare with true density:
## Omit values greater than 500 from plot
   xmpExtremes("\nNext: Plot Empirical and True Density >")
   hist(r, n = 50, probability = TRUE, xlab = "r", 
     xlim = c(-5, 5), ylim = c(0, 1.1), main = "Density")
   x = seq(-5, 5, by = 0.01)
   lines(x, dgpd(x, xi = 1/4), col = "steelblue3")
   
## Plot df and compare with true df:
   xmpExtremes("\nNext: Plot Empirical and True Probability >")
   plot(sort(r), (1:length(r)/length(r)), 
     xlim = c(-3, 6), ylim = c(0, 1.1),
     cex = 0.5, ylab = "p", xlab = "q", main = "Probability")
   q = seq(-5, 5, by = 0.1)
   lines(q, pgpd(q, xi = 1/4), col = "steelblue3")
   
## Compute quantiles, a test:
   xmpExtremes("\nNext: Compute Quantiles >")
   qgpd(pgpd(seq(-1, 5, 0.25), xi = 1/4 ), xi = 1/4) 
 



