### Name: GpdFit
### Title: Modelling the Generalized Pareto Distribution
### Aliases: GpdFit gpdSim gpdFit print.gpdFit plot.gpdFit summary.gpdFit
###   gpdqPlot gpdquantPlot gpdriskmeasures gpdsfallPlot gpdshapePlot
###   gpdtailPlot
### Keywords: models

### ** Examples

## SOURCE("fExtremes.53B-GpdFit")

## Load Data:
   data(danish)
   
## gpdSim - 
   # Simulate GPD Data:
   xmpExtremes("\nStart: Simulate a GPD Distributed Sample > ")
   x = gpdSim(model = list(shape = 0.25, location = 0, scale = 1), n = 1000)
   
## gpdFit -   
   xmpExtremes("\nNext: Fit Simulated Data to GPD using PWM > ")
   fit = gpdFit(x, nextremes = length(x), type = "pwm") 
   print(fit)
   par(mfcol = c(4, 2), cex = 0.7)
   summary(fit)  
   
## gpdFit -
   xmpExtremes("\nNext: Fit Simulated Data to GPD using MLE > ")
   fit = gpdFit(x, nextremes = length(x), type = "mle") 
   print(fit)
   summary(fit) 

## gpdFit - 
   xmpExtremes("\nNext: Fit Danish Fire Data to Excess Losses over 10 > ")
   fit = gpdFit(danish, 10, type = "mle") 
   print(fit)
   par(mfrow = c(2, 2), cex = 0.7)
   summary(fit)  
     
## gpdqPlot - 
   xmpExtremes("\nNext: 99.5th Percentiles for Danish Fire Data > ")
   fit = gpdFit(danish, threshold = 10, type = "mle")
   par(mfrow = c(1, 1))
   tail = gpdtailPlot(fit)
   gpdqPlot(tail, 0.995)
   title(main = "Danish Data: 99.5th Percentile") 
        
## gpdquantPlot -       
   xmpExtremes("\nNext: 99.9th Percentiles for Danish Fire Data > ")
   par(mfrow = c(1, 1))
   gpdquantPlot(danish, p = 0.999)
   title(sub = "Danish Fire: GPD High Quantile") 

## gpdsfallPlot - 
   xmpExtremes("\nNext: Expected Shortfall for Danish Fire Data > ")
   fit = gpdFit(danish, nextremes = floor(length(danish)/10), type = "mle")
   par(mfrow = c(1, 1))
   tp = gpdtailPlot(fit)
   gpdsfallPlot(tp, 0.999)   
   title(main = "Danish Fire: Expected Shortfall")   
   
## gpdriskmeasures -
   xmpExtremes("\nNext: Quantiles and Expected Shortfalls > ")
   # Give estimates of 0.999 and 0.9999 quantiles - Danish Fire Date:   
   fit = gpdFit(danish, threshold = 10, type = "mle") 
   par(mfrow = c(1, 1))
   gpdriskmeasures(fit, c(0.99, 0.995, 0.999, 0.9995, 0.9999))   
  
## gpdshapePlot - 
   xmpExtremes("\nNext: Shape Plot of Heavy-Tailed Simulated Data > ")
   set.seed(4711)
   par(mfrow = c(1, 1))
   gpdshapePlot(gpdSim(n = 1000))
   title(sub = "Simulated GPD", cex.sub = 0.7)   

## gpdshapePlot - 
   xmpExtremes("\nNext: Shape Plot of Heavy-Tailed Danish Fire Data > ")
   par(mfrow = c(1, 1))
   gpdshapePlot(danish)
   title(sub = "Danish Fire", cex.sub = 0.7)

## gpdtailPlot - 
   xmpExtremes("\nNext: Plot Tail Estimate of Danish Fire Data >")
   fit = gpdFit(danish, threshold = 10, type = "mle")
   par(mfrow = c(1, 1))
   gpdtailPlot(fit, main = "Danish Fire: GPD Tail Estimate", col = "steelblue4")  



