### Name: GevGlmFit
### Title: Modelling the GEV Distribution including GLM
### Aliases: GevGlmFit gevglmFit print.gevglmFit plot.gevglmFit
###   summary.gevglmFit gevglmprofPlot gevglmprofxiPlot
### Keywords: models

### ** Examples

## SOURCE("fExtremes.54A-ExtremesGlm")

## Simulated GEV Data:
   xmpExtremes("\nStart: Simulte GEV Sample >")
   x = gevSim(model = list(shape = 0.25, location = 0, scale = 1), n = 1000)
   par(mfrow = c(2, 2))
   plot(x, main = "Simulated GEV Data")
   # Fit GEV Data:
   fit = gevglmFit(x) 
   print(fit)
   # Summarize Results:
   summary(fit, which = c(TRUE, TRUE, TRUE, FALSE))
   
## Simulated GEV Data:
   xmpExtremes("\nNext: Estimate Parameters >")
   ##> x = gevSim(model = list(shape = 0, location = 0, scale = 1), n = 1000)
   ##> par(mfrow = c(2, 2))
   ##> plot(x, main = "Simulated Gumbel Data")
   # Fit GEV Data:
   ##> fit = gevglmFit(x, gumbel = TRUE) 
   ##> print(fit)
   # Summarize Results:
   ##> summary(fit, which = c(TRUE, TRUE, TRUE, FALSE))
   
## Portpirie Data:
   xmpExtremes("\nNext: Fit Portpirie Data >")
   par(mfrow = c(2, 1))
   data(portpirie)
   fit = gevglmFit(portpirie[, 2])
   gevglmprofPlot(fit, m = 10, 4.1, 5)
   title(main = "Portpirie")
   gevglmprofxiPlot(fit, -0.3, 0.3)
   title(main = "Portpirie")
   
## Interactive Plot:
   ##> par(mfrow = c(2, 2))
   ##> plot(fit)



