### Name: GpdGlmFit
### Title: Modelling the GPD Distribution including GLM
### Aliases: GpdGlmFit gpdglmFit print.gpdglmFit plot.gpdglmFit
###   summary.gpdglmFit gpdglmprofPlot gpdglmprofxiPlot
### Keywords: models

### ** Examples

## SOURCE("fExtremes.54B-GpdGlmFit")

## Use Rain Data:
   data(rain)
   
## Fit GPD Model:
   xmpExtremes("Start: Parameter Estimation >")
   fit = gpdglmFit(x = rain, threshold = 10)
   print(fit)
   xmpExtremes("Next: Summary Report > ")
   
## Summarize Results:
   xmpExtremes("Next: Profile Likelihood >")
   par(mfrow = c(2, 2), cex = 0.75)
   summary(fit, which = "all")
   # Profile Lielihood:
   par(mfrow = c(2, 1), cex = 0.75)
   gpdglmprofPlot(fit, m = 10, xlow = 55, xup = 75)
   title(main = "Rain")
   gpdglmprofxiPlot(fit, xlow = -0.02, 0.15)
   title(main = "Rain")



