### Name: AssetsModelling
### Title: Modelling of Multivariate Asset Sets
### Aliases: AssetsModelling fASSETS fASSETS-class assetsSim assetsFit
###   assetsSelect assetsStats print.fASSETS plot.fASSETS summary.fASSETS
### Keywords: models

### ** Examples

## SOURCE("fPortfolio.A1-AssetsModelling")

## berndtInvest -
   xmpPortfolio("\nStart: Load monthly data set of returns > ")
   data(berndtInvest)
   # Exclude Date, Market and Interest Rate columns from data frame,
   # then multiply by 100 for percentual returns ...
   berndtAssets = berndtInvest[, -c(1, 11, 18)]
   rownames(berndtAssets) = berndtInvest[, 1]
   head(berndtAssets)
    
## assetsSelect -
   xmpPortfolio("\nNext: Select 4 most dissimilar assets from hclust > ")
   clustered = assetsSelect(berndtAssets, doplot = FALSE)
   myAssets = berndtAssets[, c(clustered$order[1:4])]
   colnames(myAssets)
   # Scatter and time series plot:
   par(mfrow = c(2, 1), cex = 0.7)
   plot(clustered)  
   myPrices = apply(myAssets, 2, cumsum)
   ts.plot(myPrices, main = "Selected Assets", 
     xlab = "Months starting 1978", ylab = "Price", col = 1:4)
   legend(0, 3, legend = colnames(myAssets), pch = "----", col = 1:4, cex = 1)
   
## assetsStats -
   if (require(fBasics)) assetsStats(myAssets)
   
## assetsSim -
   xmpPortfolio("\nNext: Fit a Skew Student-t > ")
   fit = assetsFit(myAssets)
   # Show Model Slot:
   fit @model
   # Simulate set with same properties:
   set.seed(1953)
   simAssets = assetsSim(n = 120, dim = 4, model = fit@model)
   head(simAssets)
   simPrices = apply(simAssets, 2, cumsum)
   ts.plot(simPrices, main = "Simulated Assets", 
     xlab = "Number of Months", ylab = "Simulated Price", col = 1:4)
   legend(0, 3, legend = colnames(simAssets), pch = "----", col = 1:4, cex = 1)
   
## plot -
   xmpPortfolio("\nNext: Show Simulated Assets Plots > ")
   if (require(fExtremes)) {
     # Show Scatterplot:
     par(mfrow = c(1, 1), cex = 0.7)
     plot(fit, which = c(TRUE, FALSE, FALSE, FALSE, FALSE))
     # Show  QQ and PP Plots:
     par(mfrow = c(2, 2), cex = 0.7)
     plot(fit, which = !c(TRUE, FALSE, FALSE, FALSE, FALSE))
   }



