### Name: TwoAssetsPortfolio
### Title: Two Assets Portfolio
### Aliases: TwoAssetsPortfolio fPFOLIO2 fPFOLIO2-class
###   frontierTwoAssetsMarkowitz frontierTwoAssetsCVaR print.fPFOLIO2
###   plot.fPFOLIO2 summary.fPFOLIO2
### Keywords: data

### ** Examples

## SOURCE("fPortfolio.B3-TwoAssetsPortfolio")

## Not run: 
##D ## berndtInvest -
##D    xmpPortfolio("\nStart: Load monthly data set of returns > ")
##D    data(berndtInvest)
##D    # Select "IBM" and "DEC"
##D    twoAssets = berndtInvest[, c("IBM", "DEC")]
##D    rownames(twoAssets) = berndtInvest[, 1]
##D    head(twoAssets)
##D    
##D ## Compute Efficient Frontier:
##D    myPortfolio = frontierTwoAssetsMarkowitz(twoAssets)
##D    
##D ## Print Efficient Frontier:
##D    print(myPortfolio)
##D     
##D ## Plot Efficient Frontier:
##D    plot(myPortfolio)
##D    
##D ## Compute Efficient Frontier:
##D    myPortfolio = frontierTwoAssetsCVaR(twoAssets)
##D    
##D ## Print Efficient Frontier:
##D    print(myPortfolio)
##D     
##D ## Plot Efficient Frontier:
##D    plot(myPortfolio)
##D    
##D   
##D   
##D show =
##D function(i,j) { 
##D w = (0:100)/100
##D alpha = 0.04
##D par(mfrow = c(2,2), cex = 0.5)
##D  
##D     
##D    print(c(i, j))
##D    twoAssets = cbind(berndtInvest[, i], berndtInvest[, j])
##D    print(head(twoAssets))
##D   
##D 
##D    means = apply(twoAssets, 2, mean)
##D    x.Return = y.VaR = y.CVaR = y.CVaRplus = NULL
##D    for (k in 1:101) {
##D                 weights = c(w[k], 1-w[k])
##D                 x.Return = c(x.Return, weights 
##D                 y.VaR = c(y.VaR, -VaR(twoAssets, weights, alpha))
##D                 y.CVaR = c(y.CVaR, -CVaR(twoAssets, weights, alpha))
##D                 y.CVaRplus = c(y.CVaRplus, -CVaRplus(twoAssets, weights, alpha))
##D         }
##D         plot(x = range(x.Return), y = range(c(y.VaR, y.CVaR, y.CVaRplus)), 
##D                 xlab = as.character(i), ylab = as.character(j), type = "n")
##D         lines(x.Return, as.vector(y.VaR), col ="red")
##D         lines(x.Return, as.vector(y.CVaR), col = "green")
##D         lines(x.Return, as.vector(y.CVaRplus), col = "blue")
##D }
##D 
##D par(mfrow = c(1,1))
##D         
##D w = (0:200)/200
##D alpha = 0.04
##D for (i in 2:17) {
##D for (j in (i+1):18) {   
##D     
##D    
##D         twoAssets = cbind(berndtInvest[, i], berndtInvest[, j])
##D   
##D         means = apply(twoAssets, 2, mean)
##D         x = NULL
##D         y = NULL
##D         for (k in 1:201) {
##D                 weights = c(w[k], 1-w[k])
##D                 x = c(x, weights 
##D                 y = c(y, -CVaRplus(twoAssets, weights, alpha))
##D         }
##D         s = round(100*abs( y[201] - y[1] ) / ( max(y) - min(y)))
##D         print(c(i, j, s))
##D         plot(x, y, main = paste(as.character(i), as.character(j)))
##D }
##D }
##D         
##D 
##D         i = 5; j = 13
##D         twoAssets = cbind(berndtInvest[, i], berndtInvest[, j])         
##D         means = apply(twoAssets, 2, mean)
##D         x = y = NULL
##D         for (k in 1:201) {
##D                 weights = c(w[k], 1-w[k])
##D                 x = c(x, weights 
##D                 y = c(y, -VaR(twoAssets, weights, alpha)) }
##D         s = round(100*abs( y[201] - y[1] ) / ( max(y) - min(y)))
##D         plot(x, y, main = paste(as.character(i), as.character(j)))
##D                         
## End(Not run)
   



