### Name: ArmaModelling
### Title: Integrated ARMA Time Series Modelling
### Aliases: ArmaModelling fARMA fARMA-class armaSim armaFit predict.fARMA
###   print.fARMA plot.fARMA summary.fARMA fitted.fARMA residuals.fARMA
###   armaRoots armaTrueacf armaToeplitz armaFischer
### Keywords: models

### ** Examples

## SOURCE("fSeries.31A-ArmaModelling")

## armaSim/armaFit -
   xmpSeries("\nStart: Simulate an ARMA(2, 1) process > ")
   x = armaSim(model = list(ar = c(0.5, -0.5), ma = 0.1), n = 1000)
   Continue = xmpSeries("Press any key > ")
   # Estimate the parameters:
   fit = armaFit(x ~ arma(2, 1))
   print(fit)
   Continue = xmpSeries("Press any key > ") 
   # Diagnostic Analysis:
   par(mfrow = c(3, 2), cex = 0.7)
   summary(fit)
   Continue = xmpSeries("Press any key > ")
   # 5 Steps ahead Forecasts:
   predict(fit, 5)
     
## armaFit -
   xmpSeries("\nNext: Estimate the parameters > ")
   # Now use the arima fitting method with d=0:
   fit = armaFit(x ~ arima(2, 0, 1))
   print(fit)
   Continue = xmpSeries("Press any key > ") 
   # Diagnostic Analysis:
   par(mfrow = c(3, 2), cex = 0.7)
   summary(fit)
   Continue = xmpSeries("Press any key > ") 
   # 5 Step ahead Forecasts:
   predict(fit, n.ahead = 5)
   
## armaRoots -
   xmpSeries("\nNext: Roots of the Characteristic Polynomial > ")
   # Calculate and plot the  of an ARMA process:
   par(mfrow = c(2, 2), cex = 0.7)
   coefficients = c(-0.5, 0.9, -0.1, -0.5)
   armaRoots(coefficients)
   
## armaTrueacf -
   xmpSeries("\nNext: True ACF of an ARMA Process > ")
   model = list(ar = c(0.3, +0.3), ma = 0.1)
   armaTrueacf(model)
   model = list(ar = c(0.3, -0.3), ma = 0.1)
   armaTrueacf(model)



