### Name: UnitrootTests
### Title: Unit Root Time Series Tests
### Aliases: UnitrootTests urTest adfTest unitrootTest urdfTest urersTest
###   urkpssTest urppTest urspTest urzaTest
### Keywords: htest

### ** Examples

## SOURCE("fSeries.32B-UnitrootTests")

## Not run: 
##D ## adfTest - 
##D    xmpSeries("\nStart: Augmented Dickey-Fuller Test for Unit Roots >")
##D    # A time series which contains no unit-root:
##D    x = rnorm(1000)  
##D    adfTest(x)
##D    # A time series which contains a unit-root:
##D    y = cumsum(c(0, x))
##D    adfTest(y)
##D    
##D ## unitrootTest - 
##D    xmpSeries("\nNext: ADF Test using McKinnon's Tables >")
##D    # A time series which contains no unit-root:
##D    x = rnorm(1000)  
##D    unitrootTest(x)
##D    # A time series which contains a unit-root:
##D    y = cumsum(c(0, x))
##D    unitrootTest(y)    
##D  
##D ## Unit Root Tests build on Bernhard Pfaff's Implementation:
##D     
##D ## ur*Test - 
##D    # Examples can be found in the demo file "xmpTestUnitRoots".  
## End(Not run)




