### Name: ccsize
### Title: Power and sample size for case-cohort design
### Aliases: ccsize
### Keywords: misc

### ** Examples

## Not run: 
##D # Table 1 of Cai & Zeng (2004).
##D 
##D cat("n\tpD\tp1\ttheta\tq\tpower\n")
##D alpha <- 0.05
##D n <- 1000
##D for(pD in c(0.10,0.05))
##D {
##D    for(p1 in c(0.3,0.5))
##D    {
##D       for(theta in c(0.5,1.0))
##D       {
##D          for(q in c(0.1,0.2))
##D          {
##D             power <- ccsize(n,q,pD,p1,alpha,theta)
##D             cat(n,"\t",pD,"\t",p1,"\t",theta,"\t",q,"\t",signif(power,digits=3),"\n")
##D          }
##D       }
##D    }
##D }
##D 
##D n <- 5000
##D for(pD in c(0.05,0.01))
##D {
##D    for(p1 in c(0.3,0.5))
##D    {
##D       for(theta in c(0.5,1.0))
##D       {
##D          for(q in c(0.01,0.02))
##D          {
##D             power <- ccsize(n,q,pD,p1,alpha,theta)
##D             cat(n,"\t",pD,"\t",p1,"\t",theta,"\t",q,"\t",signif(power,digits=3),"\n")
##D          }
##D       }
##D    }
##D }
##D 
##D # ARIC study
##D 
##D n <- 15792
##D pD <- 0.03
##D p1 <- 0.25
##D alpha <- 0.05
##D theta <- c(1.35,1.40,1.45)
##D power <- 0.8
##D 
##D s_nb <- c(1463,722,468)
##D 
##D for(i in 1:3)
##D {
##D   q <- s_nb[i]/n
##D   power <- ccsize(n,q,pD,p1,alpha,log(theta[i]))
##D   ssize <- ccsize(n,q,pD,p1,alpha,log(theta[i]),power)
##D   cat(n,"\t",pD,"\t",p1,"\t",theta[i],"\t",q,"\t",signif(power,digits=3),"\t",ceiling(ssize),"\n")
##D }
##D 
##D # EPIC study?
##D 
##D n <- 25000
##D alpha <- 0.00000001
##D power <- 0.8
##D s_pD <- c(0.3,0.2,0.1,0.05)
##D s_p1 <- seq(0.1,0.5,by=0.1)
##D s_theta <- seq(1.2,1.8,by=0.2)
##D s_q <- seq(0.01,0.5,by=0.01)
##D 
##D # direct calculation
##D for(pD in s_pD)
##D {
##D    for(p1 in s_p1)
##D    {
##D       for(theta in s_theta)
##D       {
##D          ssize <- ccsize(n,q,pD,p1,alpha,log(theta),power)
##D          if(ssize>0) cat(n,"\t",pD,"\t",p1,"\t",theta,"\t",ssize,"\n")
##D       }
##D    }
##D }
##D 
##D # exhaustive search
##D nrows <- length(s_pD) * length(s_p1) * length(s_theta) * length(s_q)
##D powtable <- matrix(rep(0,nrows * 5),ncol=5,byrow=T)
##D ijkl <- 0
##D for(pD in s_pD)
##D {
##D    for(p1 in s_p1)
##D    {
##D       for(theta in s_theta)
##D       {
##D          for(q in s_q)
##D          {
##D             ijkl <- ijkl + 1
##D             power <- ccsize(n,q,pD,p1,alpha,log(theta))
##D             powtable[ijkl,] <- c(pD,p1,theta,q*n,power)
##D             cat(n,"\t",pD,"\t",p1,"\t",theta,"\t",q*n,"\t",signif(power,digits=3),"\n")
##D          }
##D       }
##D    }
##D }
## End(Not run)



