### Name: fbsize
### Title: Sample size for family-based linkage and association design
### Aliases: fbsize
### Keywords: models

### ** Examples

## Not run: 
##D models <- matrix(c(
##D     4.0, 0.01,
##D     4.0, 0.10,
##D     4.0, 0.50, 
##D     4.0, 0.80,
##D     2.0, 0.01,
##D     2.0, 0.10,
##D     2.0, 0.50,
##D     2.0, 0.80,
##D     1.5, 0.01,    
##D     1.5, 0.10,
##D     1.5, 0.50,
##D     1.5, 0.80), ncol=2, byrow=TRUE)
##D     
##D cat("\nThe family-based result: \n")
##D cat("\ngamma   p     Y     N_asp   P_A    Het    N_tdt  Het N_asp/tdt  L_o  L_s\n\n")
##D for(i in 1:12) {
##D   g <- models[i,1]
##D   p <- models[i,2]
##D   fbsize(g,p)
##D   if(i%%4==0) cat("\n")
##D }
##D 
##D # APOE-4, Scott WK, Pericak-Vance, MA & Haines JL
##D # Genetic analysis of complex diseases 1327
##D g <- 4.5
##D p <- 0.15
##D cat("\nAlzheimer's:\n\n")
##D fbsize(g,p)
## End(Not run)



