### Name: pbsize
### Title: Power for population-based association design
### Aliases: pbsize
### Keywords: models

### ** Examples

## Not run: 
##D models <- matrix(c(
##D     4.0, 0.01,
##D     4.0, 0.10,
##D     4.0, 0.50, 
##D     4.0, 0.80,
##D     2.0, 0.01,
##D     2.0, 0.10,
##D     2.0, 0.50,
##D     2.0, 0.80,
##D     1.5, 0.01,    
##D     1.5, 0.10,
##D     1.5, 0.50,
##D     1.5, 0.80), ncol=2, byrow=TRUE)
##D     
##D g <- 4.5
##D p <- 0.15
##D cat("\nAlzheimer's:\n\n")
##D  
##D zalpha <- 5.45   # 5.4513104
##D z1beta <- -0.84
##D 
##D q <- 1-p
##D pi <- 0.065      # 0.07 generates 163, equivalent to ASP
##D k <- pi*(g*p+q)^2
##D s <- (1-pi*g^2)*p^2+(1-pi*g)*2*p*q+(1-pi)*q^2
##D # LGL formula
##D lambda <- pi*(g^2*p+q-(g*p+q)^2)/(1-pi*(g*p+q)^2)
##D # my own
##D lambda <- pi*p*q*(g-1)^2/(1-pi*(g*p+q)^2)
##D # not sure about +/-!
##D n <- (z1beta+zalpha)^2/lambda
##D 
##D # may be used to correct for population prevalence
##D cat("\nThe population-based result: Kp=",k, "Kq=",s, "n=",ceiling(n),"\n")
##D 
##D # population-based sample size
##D strlen <- function(x) length(unlist(strsplit(as.character(x),split="")))
##D kp <- c(0.01,0.05,0.10)
##D cat("\nRandom ascertainment with disease prevalence\n")
##D cat("\n          1%          5%         10%\n\n")
##D for(i in 1:12) {
##D   g <- models[i,1]
##D   p <- models[i,2]
##D   q <- 1-p
##D   for(j in 1:3) {
##D     n <- pbsize(g,p,kp[j])
##D     cat(rep("",12-strlen(ceiling(n))),format(ceiling(n)))
##D   }
##D   cat("\n")
##D   if(i%%4==0) cat("\n")
##D } 
##D cat("This is only an approximation, a more accurate result\n")
##D cat("can be obtained by Fisher's exact test\n")
## End(Not run)



