### Name: fitCovGraph
### Title: Fitting of Gaussian covariance graph models
### Aliases: fitCovGraph
### Keywords: graphs models multivariate

### ** Examples

## Correlations among four strategies to cope with stress for 
## 72 students. Cox & Wermuth (1996), p. 73.
##  Y = cognitive avoidance
##  X = vigilance
##  V = blunting
##  U = monitoring

R <- matrix(c(
   1.00, -0.20,  0.46,  0.01,
  -0.20,  1.00,  0.00,  0.47,
   0.46,  0.00,  1.00, -0.15,
   0.01,  0.47, -0.15,  1.00), 4, 4)
nam <- c("Y", "X", "V", "U") 
dimnames(R) <- list(nam, nam)

## A chordless 4-cycle covariance graph
gr <- UG(~ Y*X + X*U + U*V + V*Y)
fitCovGraph(gr, R, n=72)
fitCovGraph(gr, R, n=72, alg="dual")



