### Name: ggtile
### Title: Grob function: tile
### Aliases: ggtile
### Keywords: hplot

### ** Examples
pp <- function (n,r=4) {
x <- seq(-r*pi, r*pi, len=n)
df <- expand.grid(x=x, y=x)
df$r <- sqrt(df$x^2 + df$y^2)
df$z <- cos(df$r^2)*exp(-df$r/6)
df
}
p <- ggplot(pp(20), aes=list(x=x,y=y))
ggtile(p) #pretty useless!
ggtile(p, list(fill=z))
ggtile(p, list(height=abs(z), width=abs(z)))
ggtile(ggplot(pp(100), aes=list(x=x,y=y,fill=z)))
ggtile(ggplot(pp(100, r=2), aes=list(x=x,y=y,fill=z)))
p <- ggplot(pp(20)[sample(20*20, size=200),], aes=list(x=x,y=y,fill=z))
ggtile(p)


