### Name: kernelMatrix
### Title: Kernel Matrix functions
### Aliases: kernelMatrix kernelMult kernelPol kernelFast
###   kernelPol,kernel-method kernelMatrix,kernel-method
###   kernelMult,kernel-method kernelFast,kernel-method
###   kernelMatrix,rbfkernel,matrix-method
###   kernelMatrix,polykernel,matrix-method
###   kernelMatrix,vanillakernel,matrix-method
###   kernelMatrix,tanhkernel,matrix-method
###   kernelMatrix,laplacekernel,matrix-method
###   kernelMatrix,anovakernel,matrix-method
###   kernelMatrix,splinekernel,matrix-method
###   kernelMatrix,besselkernel,matrix-method
###   kernelMatrix,stringkernel-method kernelMult,rbfkernel,matrix-method
###   kernelMult,splinekernel,matrix-method
###   kernelMult,polykernel,matrix-method
###   kernelMult,tanhkernel,matrix-method
###   kernelMult,laplacekernel,matrix-method
###   kernelMult,besselkernel,matrix-method
###   kernelMult,anovakernel,matrix-method
###   kernelMult,vanillakernel,matrix-method
###   kernelMult,character,kernelMatrix-method
###   kernelMult,stringkernel-method kernelPol,rbfkernel,matrix-method
###   kernelPol,splinekernel,matrix-method
###   kernelPol,polykernel,matrix-method kernelPol,tanhkernel,matrix-method
###   kernelPol,vanillakernel,matrix-method
###   kernelPol,anovakernel,matrix-method
###   kernelPol,besselkernel,matrix-method
###   kernelPol,laplacekernel,matrix-method kernelPol,stringkernel-method
###   kernelFast,rbfkernel,matrix-method
###   kernelFast,splinekernel,matrix-method
###   kernelFast,polykernel,matrix-method
###   kernelFast,tanhkernel,matrix-method
###   kernelFast,vanillakernel,matrix-method
###   kernelFast,anovakernel,matrix-method
###   kernelFast,besselkernel,matrix-method
###   kernelFast,laplacekernel,matrix-method kernelFast,stringkernel-method
###   kernelFast,splinekernel-method
### Keywords: algebra array

### ** Examples

## use the spam data
data(spam)
dt <- as.matrix(spam[c(10:20,3000:3010),-58])

## initialize kernel function 
rbf <- rbfdot(sigma = 0.05)
rbf

## calculate kernel matrix
kernelMatrix(rbf, dt)

yt <- as.matrix(as.integer(spam[c(10:20,3000:3010),58]))
yt[yt==2] <- -1

## calculate the quadratic kernel expression
kernelPol(rbf, dt, ,yt)

## calculate the kernel expansion
kernelMult(rbf, dt, ,yt)



