### Name: familycheck
### Title: Error check for a family classification
### Aliases: familycheck
### Keywords: manip

### ** Examples

## Not run: 
##D #
##D # This is from a pedigree that had some identifier errors
##D #
##D > checkit<- familycheck(ids2$famid, ids2$gid, ids2$fatherid, ids2$motherid)
##D > table(checkit$split)    # should be all 1's
##D    0   1 2 
##D  112 424 4
##D # Shows 112 of the "families" were actually isolated individuals,
##D #  and that 4 of the families actually split into 2.  
##D #  In one case, a mistyped father id caused one child, along with his spouse
##D #  and children, to be "set adrift" from the connected pedigree.
##D 
##D > table(checkit$join)
##D    0 1 2 
##D  531 6 3
##D #
##D # There are 6 families with 1 other joined to them (3 pairs), and 3 with
##D #  2 others added to them (one triplet).
##D # For instance, a single mistyped father id of someone in family 319,
##D #  which was by bad luck the id of someone else in family 339,
##D #  was sufficient to join two groups.
##D > attr(checkit, 'join')
##D     [,1] [,2] [,3] [,4] [,5] [,6] [,7] 
##D  31   78    0    0    0    0    0    0
##D  32    3   15    0    0    0    0    0
##D  33    6    0   12    0    0    0    0
##D  63    0    0    0   63    0    0    0
##D  65    0    0    0   17   16    0    0
##D 122    0    0    0    0    0   16    0
##D 127    0    0    0    0    0   30    0
##D 319    0    0    0    0    0    0   20
##D 339    0    0    0    0    0    0   37
## End(Not run)



