### Name: gchol
### Title: Generalized Cholesky decompostion
### Aliases: gchol gchol.bdsmatrix
### Keywords: array

### ** Examples

## Not run: 
##D # Create a matrix that is symmetric, but not positive definite
##D #   The matrix temp has column 6 redundant with cols 1-5
##D smat <- matrix(1:64, ncol=8)
##D smat <- smat + t(smat) + diag(rep(20,8))  #smat is 8 by 8 symmetric
##D temp <-  smat[c(1:5, 5:8), c(1:5, 5:8)]
##D ch1  <- gchol(temp)
##D 
##D print(as.matrix(ch1))   # print out L
##D print(diag(ch1))        # print out D
##D aeq <- function(x,y) all.equal(as.vector(x), as.vector(y))
##D aeq(diag(ch1)[6], 0)    # Check that it has a zero in the proper place
##D 
##D ginv <- solve(ch1)    # see if I get a generalized inverse
##D aeq(temp %*% ginv %*% temp, temp)
##D aeq(ginv %*% temp %*% ginv, ginv)
## End(Not run)



