### Name: lmekin
### Title: Linear Mixed Effects model using a kinship matrix.
### Aliases: lmekin print.lmekin getCovariateFormula2 getCrossedTerms
###   getGroupsFormula2
### Keywords: regression

### ** Examples

## Not run: 
##D #
##D # Make a kinship matrix for the entire study
##D # These two functions are NOT fast, the makekinship one in particular
##D #
##D cfam <- makefamid(main$gid, main$momid, main$dadid)
##D kmat <- makekinship(cfam, main$gid, main$momid, main$dadid)
##D 
##D # The kinship matrix for the females only: quite a bit smaller
##D #
##D kid <- dimnames(kmat)[[1]]
##D temp <- main$sex[match(kid, main$gid)] == 'F'
##D fkmat <- kmat[temp,temp]
##D 
##D # The dimnames on kmat are the gid value, which are necessary to match
##D #  the appropriate row/col of kmat to the analysis data set
##D # A look at %dense tissue on a mammogram, with age at mammogram and
##D #  weight as covariates, and a familial random effect
##D #
##D fit <- lmekin(percdens ~ mammage + weight, data=anal1,
##D                  random = ~1|gid, varlist=list(fkmat))
##D 
##D Linear mixed-effects kinship model fit by maximum likelihood
##D   Data: anal1 
##D   Log-likelihood = -6093.917 
##D   n= 1535 
##D 
##D Fixed effects: percdens ~ mammage + weight 
##D  (Intercept)    mammage     weight 
##D      87.1593 -0.5333198 -0.1948871
##D 
##D Random effects:  ~ 1 | gid 
##D          Kinship Residual 
##D StdDev: 7.801603 10.26612
## End(Not run)



