### Name: plot.pedigree
### Title: plot pedigrees
### Aliases: plot.pedigree
### Keywords: hplot

### ** Examples

## Not run: 
##D # The original example
##D ptemp <- pedigree(id=d10$upn, dadid=d10$dadid, momid=d10$momid, 
##D                   sex=d10$sex, affected=d10$affect)
##D 
##D plot(ptemp)
##D 
##D col.founder <- rep(1,length(d10$affect))
##D col.founder[d10$id==1] <- 2
##D 
##D plot(ptemp, affected=cbind(d10$affect,d10$affect2,d10$affect3,d10$affect4),
##D      col=col.founder, id=paste(ptemp$id,'\n','(',d10$post,')',sep=''),
##D      angle=c(90,80,70,60), density=c(-1,90,70,50))
##D 
##D # The example to R News and Bioinformatics
##D # pedigree 10081 in GAW14
##D p1 <- scan(nlines=16,what=list(0,0,0,0,0,"",""))
##D  1   2   3  2  2  7/7  7/10 
##D  2   0   0  1  1  -/-  -/-  
##D  3   0   0  2  2  7/9  3/10 
##D  4   2   3  2  2  7/9  3/7  
##D  5   2   3  2  1  7/7  7/10 
##D  6   2   3  1  1  7/7  7/10 
##D  7   2   3  2  1  7/7  7/10 
##D  8   0   0  1  1  -/-  -/-  
##D  9   8   4  1  1  7/9  3/10 
##D 10   0   0  2  1  -/-  -/- 
##D 11   2  10  2  1  7/7  7/7 
##D 12   2  10  2  2  6/7  7/7 
##D 13   0   0  1  1  -/-  -/- 
##D 14  13  11  1  1  7/8  7/8 
##D 15   0   0  1  1  -/-  -/- 
##D 16  15  12  2  1  6/6  7/7 
##D 
##D p2 <- as.data.frame(p1)
##D names(p2) <- c("id","fid","mid","sex","aff","GABRB1","D4S1645")
##D attach(p2)
##D sex <- sex-1
##D p3 <- pedigree(id,fid,mid,sex,aff)
##D pdf("10081.pdf")
##D par(xpd=TRUE)
##D plot(p3)
##D dev.off()
## End(Not run)



