SS.oneway.bf            package:ldDesign            R Documentation

_B_a_y_e_s _f_a_c_t_o_r_s _f_o_r _o_n_e-_w_a_y _a_n_a_l_y_s_i_s _o_f _v_a_r_i_a_n_c_e _m_o_d_e_l_s.

_D_e_s_c_r_i_p_t_i_o_n:

     Function to calculate the Bayes factor for a one-way analysis of
     variance layout with vague or improper priors.

_U_s_a_g_e:

     SS.oneway.bf(group.sizes, Fstat)

_A_r_g_u_m_e_n_t_s:

group.sizes: Sizes of groups in the one-way layout

   Fstat: F statistic obtained

_D_e_t_a_i_l_s:

     The function the Bayes factor corresponding to a given F statistic
     in a one-way analysis of variance model is calculated using the
     method  of Spiegelhalter and Smith 1982. With improper priors the
     marginal probabilities of the data under each of the models
     (corresponding to the NULL and alternative hypotheses) is
     indeterminate. This is resolved by updating each prior with a
     small imaginary training sample, which is equivalent to
     normalising the Bayes factor to be 1 for the small training
     sample. Spiegelhalter and Smith obtain a formula for the Bayes
     factor in terms of the classical F value.

_V_a_l_u_e:

     Returns the Bayes factor corresponding to the given design and
     observed value of F statistic.

_A_u_t_h_o_r(_s):

     Rod Ball rod.ball@forestresearch.co.nz  <URL:
     www.forestresearch.co.nz>

_R_e_f_e_r_e_n_c_e_s:

     Spiegelhalter, D. and A.F.M. Smith 1982 Bayes factors for linear
     and log-linear models with vague prior information J. Royal
     Statist Soc. B 44: 377-387.

_S_e_e _A_l_s_o:

     'oneway.bf.alpha','oneway.bf.alpha.required'

_E_x_a_m_p_l_e_s:

     # Bayes factors corresponding to P-values 0.05,0.01,0.001,0.0001 for n=200
     SS.oneway.bf(group.sizes=c(50,100,50),Fstat=qf(0.95,2,197))
     SS.oneway.bf(group.sizes=c(50,100,50),Fstat=qf(0.99,2,197))
     SS.oneway.bf(group.sizes=c(50,100,50),Fstat=qf(0.999,2,197))
     SS.oneway.bf(group.sizes=c(50,100,50),Fstat=qf(0.9999,2,197))

