### Name: readMps
### Title: read MPS files
### Aliases: readMps
### Keywords: optimize

### ** Examples


## example of Steinhauser, Langbehn and Peters (1992)
## Not run: library( linprog )

## Production activities
cvec <- c(1800, 600, 600)  # gross margins
names(cvec) <- c("Milk","Bulls","Pigs")

## Constraints (quasi-fix factors)
bvec <- c(40, 90, 2500)  # endowment
names(bvec) <- c("Land","Stable","Labor")

## Needs of Production activities
Amat <- rbind( c(  0.7,   0.35,   0 ),
               c(  1.5,   1,      3 ),
               c( 50,    12.5,   20 ) )

## Write to MPS file
writeMps( "steinh.mps", cvec, bvec, Amat, "Steinhauser" )

## delete all LP objects
rm( cvec, bvec, Amat )

## Read LP data from MPS file and solve it.
lp <- readMps( "steinh.mps", TRUE, TRUE )

## Print the results
lp$res




