### Name: createData
### Title: Calculate and create a data object for Micro Array experiment
### Aliases: createData
### Keywords: utilities

### ** Examples

#################
# 2-dye arrays
#################
data(paigen)
# create data object with replicate
data2 <- createData(paigen.raw, n.rep=2)
# summarize the data object
summary(data2)
# create data with averaging of replicates
data1 <- createData(paigen.raw, n.rep=2, avgreps=1)
summary(data1)

####################################################################
# affy array - data is pre-transformed so log2 is skipped
####################################################################
data(abf1)
abf1 <- createData(abf1.raw, n.rep=1, log.trans=FALSE)
summary(abf1)



