### Name: mimR-ReadingData
### Title: Creation of gmData objects
### Aliases: gmData as.gmData as.gmData.data.frame as.gmData.table
###   as.gmData.suffStats as.gmData.list description description.gmData
###   description<- description<-.gmData latent latent.gmData latent<-
###   latent<-.gmData vallabels vallabels.gmData vallabels<-
###   vallabels<-.gmData observations obs observations.gmData
###   observations<- observations<-.gmData
### Keywords: models

### ** Examples

# A meta data object (without data)
gmd.rats.nodata  <-  gmData(c("Sex","Drug","W1","W2"),
    factor=c(2,3,FALSE,FALSE),
    vallabels=list("Sex"=c("M","F"), "Drug"=c("D1","D2","D3")))

# Note care should be taken to be consistent when specifying vallabels manually:

#This works
nt1  <-  gmData(c("Sex","Drug","W1","W2"),factor=c(2,3,FALSE,FALSE))
vallabels(nt1)

#This works
nt12  <-  gmData(c("Sex","Drug","W1","W2"),factor=c(2,3,FALSE,FALSE), vallabels=list("Sex"=c(1,2), "Drug"=c(1,2,3)))
vallabels(nt1)

## Not run: 
##D #This will not work
##D nt1  <-  gmData(c("Sex","Drug","W1","W2"),factor=c(2,3,FALSE,FALSE), vallabels=list("Sex"=c(1,2,3), "Drug"=c(1,2,3)))
##D vallabels(nt1)
##D 
##D #This will not work
##D nt1  <-  gmData(c("Sex","Drug","W1","W2"),factor=c(2,3,FALSE,FALSE), vallabels=list("Sex"=c(1,2,3)))
##D vallabels(nt1)
##D 
##D # It is possible to specify data as sufficient statistics, when these
##D # are specified as lists as follows:
##D 
##D # Specify data as sufficient statistics - discrete data
##D dat <- list(names=c("foo","bar","off"),levels=c(2,3,2),counts=1:12)
##D v <- as.gmData(dat)
##D 
##D # Specify data as sufficient statistics - continuous data
##D setosa <- subset(iris, Species=="setosa")[,1:4]
##D dat <- list(names=names(setosa), means=apply(setosa,2,mean),
##D   stddev = sqrt(diag(var(setosa))), corr=cor(setosa),n=nrow(setosa))
##D v <- as.gmData(dat)
##D 
##D # Reading sufficient statistics - continuous data
##D 
##D suffc<-list(means=apply(mathmark,2,mean),
##D stddev=apply(mathmark,2,sd), corr=cor(mathmark),n=nrow(mathmark))
##D 
##D toMIM(as.gmData(suffc))
##D # Reading sufficient statistics - discrete data
##D # Note that data are read in the order (1 1) (1 2) (2 1) (2 2)
##D suffd<-list(names=c("foo","bar"),levels=c(2,2),
##D counts=c(1,2,3,4),vallabels=list(foo=c("f1","f2"),bar=c("b1","b2")))
##D toMIM(as.gmData(suffd))
##D 
##D # Work with sufficient statistics, e.g. the hiv data taken from the SIN
##D # package
##D data(hiv)
##D v<-as.gmData(hiv)
##D fit(mim(".",data=v))
##D 
## End(Not run)

data(rats)

#NOTE: This works, but it should not because names in 'data' is not checked for consistency with what is specified
nt1  <-  gmData(c("Sex","Drug","W1","W2"),factor=c(2,3,FALSE,FALSE), vallabels=list("Sex"=c(1,2), "Drug"=c(1,2,3)), data=rats)
vallabels(nt1)

# Sending a data frame to MIM
gm.rats <- as.gmData(rats)
toMIM(gm.rats)



