symbol.plot            package:mvoutlier            R Documentation

_S_y_m_b_o_l _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     The function symbol.plot plots the (two-dimensional) data using
     different symbols according to the robust mahalanobis distance
     based on the mcd estimator with adjustment.

_U_s_a_g_e:

     symbol.plot(x, quan=1/2, alpha=0.025, ...)

_A_r_g_u_m_e_n_t_s:

       x: two dimensional matrix or data.frame containing the data.

    quan: amount of observations which are used for mcd estimations. 
          has to be between 0.5 and 1, default ist 0.5

   alpha: amount of observations used for calculating the adjusted
          quantile (see function arw).

     ...: additional graphical parameters

_D_e_t_a_i_l_s:

     The function symbol.plot plots the (two-dimensional) data using
     different symbols. In addition a legend and four ellipsoids are
     drawn, on which mahalanobis distances are constant.  As the legend
     shows, these constant values correspond to the 25%, 50%, 75% and
     adjusted  (see function arw) quantiles of the chi-square
     distribution.

_V_a_l_u_e:

outliers: boolean vector of outliers

      md: robust mahalanobis distances of the data

_A_u_t_h_o_r(_s):

     Moritz Gschwandtner <e0125439@student.tuwien.ac.at> 
      Peter Filzmoser <P.Filzmoser@tuwien.ac.at> <URL:
     http://www.statistik.tuwien.ac.at/public/filz/>

_R_e_f_e_r_e_n_c_e_s:

     P. Filzmoser, R.G. Garrett, and C. Reimann (2005). Multivariate
     outlier detection in exploration geochemistry. _Computers &
     Geosciences_. To appear.

_S_e_e _A_l_s_o:

     'dd.plot', 'color.plot', 'arw'

_E_x_a_m_p_l_e_s:

     # create data:
     x <- cbind(rnorm(100), rnorm(100))
     y <- cbind(rnorm(10, 5, 1), rnorm(10, 5, 1))
     z <- rbind(x,y)
     # execute:
     symbol.plot(z, quan=0.75)

