### Name: cforest
### Title: Random Forest
### Aliases: cforest
### Keywords: tree

### ** Examples


    ### honest (i.e., out-of-bag) cross-classification of
    ### true vs. predicted classes
    table(mammoexp$ME, predict(cforest(ME ~ ., data = mammoexp, 
                               control = cforest_control(ntree = 50)),
                               OOB = TRUE))

    ### fit forest to censored response
    if (require("ipred")) {

        data("GBSG2", package = "ipred")
        bst <- cforest(Surv(time, cens) ~ ., data = GBSG2, 
                   control = cforest_control(ntree = 50))

        ### estimate conditional Kaplan-Meier curves
        treeresponse(bst, newdata = GBSG2[1:2,], OOB = TRUE)

        ### if you can't resist to look at individual trees ...
        party:::prettytree(bst@ensemble[[1]], names(bst@data@get("input")))
    }



