### Name: Memory Allocation
### Title: Memory Allocation
### Aliases: ctree_memory
### Keywords: misc

### ** Examples


    ### setup learning sample
    airq <- subset(airquality, !is.na(Ozone))
    ls <- dpp(conditionalTree, Ozone ~ ., data = airq)

    ### setup memory and controls 
    mem <- ctree_memory(ls)
    ct <- ctree_control(teststat = "max")

    ### fit 50 trees on bootstrap samples
    bs <- rmultinom(50, nrow(airq), rep(1, nrow(airq))/nrow(airq))
    storage.mode(bs) <- "double"
    cfit <- conditionalTree@fit
    system.time(ens <- apply(bs, 2, function(w) cfit(ls, ct, weights = w, 
                                                     fitmem = mem)))




