### Name: permtest
### Title: Permutation test for testing two groups for a variability or
###   location difference.
### Aliases: permtest
### Keywords: misc utilities

### ** Examples

#Make a data set with no pairing, slight group mean differences and slight differences in variation
datamatrix<-matrix(data=c(
#group 1
rnorm(4000,.1,1.25),
#group 2
rnorm(4000,0,1) ),ncol=10,nrow=800);
designmatrix<-matrix(data=as.matrix(list("ad1","1","0","ad2","1","0","ad3","1","0","ad4","1","0","ad5","1","0","nd1","2","0","nd2","2","0","nd3","2","0","nd4","2","0","nd5","2","0")),nrow=3,ncol=10);
colnames(designmatrix)<-designmatrix[1,];
colnames(datamatrix)<-colnames(designmatrix);
designmatrix<-t(designmatrix);
#run as a randomized model with default 1000 permutations. 
permtest(datamatrix,designmatrix)

#Add pairing information, we can run as paired
#each pair item follows it's group's mean and std dev
#each pair has a common mean and deviation deflection
datamatrix<-matrix(data=c(

#group 1 mean is .1, std dev 1.25
rnorm(800,.11,1.25),    #pair 1
rnorm(800,.2 ,1.55),    #pair 2
rnorm(800,.1 ,1.25),    #pair 3
rnorm(800,.1 ,1.15),    #pair 4
rnorm(800,.13,1.25),    #pair 5
#group 2 mean is 0, std dev 1
rnorm(800,.01, 1),      #pair 1
rnorm(800,.1 , 1.3),    #pair 2
rnorm(800, 0 , 1),      #pair 3
rnorm(800, 0 ,.9),      #pair 4
rnorm(800,.03, 1),      #pair 5

),ncol=10,nrow=800);
designmatrix<-matrix(data=as.matrix(list("ad1","1","nd1","ad2","1","nd2","ad3","1","nd3","ad4","1","nd4","ad5","1","nd5","nd1","2","ad1","nd2","2","ad2","nd3","2","ad3","nd4","2","ad4","nd5","2","ad5")),nrow=3,ncol=10);
colnames(designmatrix)<-designmatrix[1,];
colnames(datamatrix)<-colnames(designmatrix);
designmatrix<-t(designmatrix);
permtest(datamatrix,designmatrix,designtype="paired")



