### Name: PT
### Title: Traverse rpart object using Tcl Tk GUI
### Aliases: PT
### Keywords: iplot tree

### ** Examples

#
# Load rpart library (needed for tree building and execution of PT
#
library("rpart")
library("tcltk")
data("mpincdf99")
#
# Use supplied function to create a suitable example.
#
z.edm <- makeEDMtree()
#
# Plot tree to look at the basic structure
#
plot(z.edm)
text(z.edm)
#
# Now use PT to graphically traverse tree
#
data("edmbigtext")
## Not run:  PT(z.edm, textfn=edm.text)
#
# Successive widgets appear. You can answer each one using the
# default options if you like (the final classification will be
# "Conservative". 
#
# If you have more time then notice that the order of questioning
# and your answers follow the edge structure of the tree.
#
# Notice the large amount of text supplied with each question (variable)
# This is achieved by the edm.text function.
#



