### Name: pinktoe
### Title: Pinktoe: convert S trees to web files for interactive traversal.
### Aliases: pinktoe
### Keywords: iplot tree

### ** Examples

#
# Attach rpart library
#
library("rpart")
data("mpincdf99")
#
# Create a tree (rpart object)
#
z.edm <- makeEDMtree()
#
# Plot the tree to see its basic structure.
#
plot(z.edm)
text(z.edm)
#
# Now use pinktoe to generate a set of htm and pl files that can be used
# by a CGI-enabled web server to traverse the tree.
#
data("edmbigtext")
#
# Next code requires "sfsmisc" library. This is not installed by default
# in R distributions so you'll have to get it yourself. We make sure
# that the next code doesn't run because R CMD check can't install packages (I think)
#
## Not run: 
##D pinktoe(z.edm, edm.text, partytittext, treeid="", localdir="./",
##D     cgibindir="/~magpn/cgi-bin/TEST/",  
##D     htmldir="/home/magpn/public_html/TEST/", stateprintfn=partyprint, 
##D     requirelib="../party.lib", 
##D     commonhtml=partycommonhtml)  
## End(Not run)
# Frame row number is  1 
# Node number is  1 
# Frame row number is  2 
# Node number is  2 
# Frame row number is  3 
# Node number is  4 
# Frame row number is  4 
# Node number is  8 
# Frame row number is  6 
# Node number is  17 
# Frame row number is  7 
# Node number is  34 
# Frame row number is  8 
# Node number is  68 
# Frame row number is  9 
# Node number is  136 
# Frame row number is  17 
# Node number is  3 
#
# If you look in the current directory you'll find a load of perl and
# HTML files created.
#



