### Name: pv99tompall
### Title: Permutation vector from MP lists in 99 into the mpall3 database
### Aliases: pv99tompall
### Keywords: datasets

### ** Examples

data(pv99tompall)
data(mpall3)
data(mpinc99)
#
# In the mpincdf object (which records EDM signings) Irene Adams is MP number 2. Let's check this
#
dimnames(mpinc99)[[1]][1:5]
#[1] "Abbott/Diane"      "Adams/Irene"       "Ainger/Nick"      
#[4] "Ainsworth/Peter"   "Alexander/Douglas"
#
# What number is she in the mpall3 database?
#
pv99tompall[2]
# [1] 3
#
# She is the third MP in this structure. (You see possibly number 1 or 2 in mpall3 did not sign anything
# in 1999.
#
# Let's check
#
mpall3$mpn[3]
#[1] Adams, Irene
#670 Levels: Abbott, Miss Diane Adams, Gerry# Adams, Irene ... Young, Rt Hon Sir George Bt
#
# Yep, that's her!



