### Name: splits.rpart
### Title: Create splits data frame that seems to be missing from R rpart
###   code
### Aliases: splits.rpart
### Keywords: iplot tree

### ** Examples

    library("rpart")
    data(kyphosis)      
    z.kyphosis <- rpart(kyphosis) 
#
#   Now check that there is no splits.cutleft or splits.cutright component
#   of the frame component as there is in S
#
    dimnames(z.kyphosis$frame)[[2]]
#
#[1] "var"        "n"          "wt"         "dev"        "yval"      
#[6] "complexity" "ncompete"   "nsurrogate" "yval2"     
#
# Nope! So let's use our function to make them
#
    splits.rpart(z.kyphosis)
#
#  splits.cutleft splits.cutright
#1          >=8.5           < 8.5
#2         >=14.5          < 14.5
#3                               
#4           < 55            >=55
#5                               
#6          >=111           < 111
#7                               
#8                               
#9                               
#
# The resultant object could be installed into the frame component
# (as happens in the early code lines of PT and pinktoe) by
#
# z.kyphosis$frame <- cbind(z.kyphosis$frame, splits.rpart(z.kyphosis))



