### Name: predict.zeroinfl
### Title: Generate predictions from zero-inflated regression count models
### Aliases: predict.zeroinfl
### Keywords: models regression

### ** Examples

data(bioChemists)
zip <- zeroinfl(count=art ~ .,
                x = ~ fem + mar + kid5 + phd + ment,
                z = ~ fem + mar + kid5 + phd + ment,
                data=bioChemists,trace=TRUE)

newdata <- expand.grid(list(fem="Men",
                            mar="Married",
                            kid5=1,
                            phd=3.103,
                            ment=0:77))

yhat <- predict(zip,newdata=newdata,
                se.fit=TRUE,MC=2500)

## Not run: 
##D plot(x=newdata$ment,
##D      y=yhat$yhat,
##D      xlab="Mentor Articles",
##D      ylab="Predicted Counts",
##D      ylim=range(zip$y),
##D      type="n")
##D polygon(x=c(newdata$ment,rev(newdata$ment)),
##D         y=c(yhat$lower,rev(yhat$upper)),
##D         border=FALSE,
##D         col=gray(.75))
##D lines(x=newdata$ment,
##D       y=yhat$yhat,
##D       lwd=2)
##D rug(quantile(bioChemists$ment,c(.05,.50,.95)))
##D title("Predicted Counts and 95
## End(Not run)



